/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.gui.modular.lib.geometry;

import codechicken.lib.gui.modular.elements.GuiElement;
import codechicken.lib.gui.modular.lib.Constraints;
import codechicken.lib.gui.modular.lib.geometry.Axis;
import codechicken.lib.gui.modular.lib.geometry.AxisConfig;
import codechicken.lib.gui.modular.lib.geometry.Constraint;
import codechicken.lib.gui.modular.lib.geometry.GeoParam;
import codechicken.lib.gui.modular.lib.geometry.GeoRef;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.lib.geometry.Position;
import codechicken.lib.gui.modular.lib.geometry.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConstrainedGeometry<T extends ConstrainedGeometry<T>>
implements GuiParent<T> {
    private Constraint xMin = null;
    private Constraint xMax = null;
    private Constraint xSize = null;
    private AxisConfig xAxis = AxisConfig.NONE;
    private Constraint yMin = null;
    private Constraint yMax = null;
    private Constraint ySize = null;
    private AxisConfig yAxis = AxisConfig.NONE;
    private final Position position = Position.create(this);
    private final Rectangle rectangle = Rectangle.create(this);
    private final Rectangle.Mutable childBounds = this.getRectangle().mutable();
    private boolean strictMode = false;

    @NotNull
    public abstract GuiParent<?> getParent();

    public GeoRef getParent(GeoParam param) {
        return this.getParent().get(param);
    }

    public T setXPos(double x) {
        GeoRef parentLeft = this.getParent(GeoParam.LEFT);
        return this.constrain(GeoParam.LEFT, Constraint.relative(parentLeft, x - parentLeft.get()));
    }

    public T setYPos(double y) {
        GeoRef parentTop = this.getParent(GeoParam.LEFT);
        return this.constrain(GeoParam.LEFT, Constraint.relative(parentTop, y - parentTop.get()));
    }

    public T setPos(double x, double y) {
        return ((ConstrainedGeometry)this.setXPos(x)).setYPos(y);
    }

    public T setWidth(double width) {
        return this.constrain(GeoParam.WIDTH, Constraint.literal(width));
    }

    public T setHeight(double height) {
        return this.constrain(GeoParam.HEIGHT, Constraint.literal(height));
    }

    public T setSize(double width, double height) {
        return ((ConstrainedGeometry)this.setWidth(width)).setHeight(height);
    }

    @Override
    public double xMin() {
        return (Double)this.xAxis.min.apply((Object)this.xMin, (Object)this.xMax, (Object)this.xSize);
    }

    @Override
    public double xMax() {
        return (Double)this.xAxis.max.apply((Object)this.xMin, (Object)this.xMax, (Object)this.xSize);
    }

    @Override
    public double xSize() {
        return (Double)this.xAxis.size.apply((Object)this.xMin, (Object)this.xMax, (Object)this.xSize);
    }

    @Override
    public double yMin() {
        return (Double)this.yAxis.min.apply((Object)this.yMin, (Object)this.yMax, (Object)this.ySize);
    }

    @Override
    public double yMax() {
        return (Double)this.yAxis.max.apply((Object)this.yMin, (Object)this.yMax, (Object)this.ySize);
    }

    @Override
    public double ySize() {
        return (Double)this.yAxis.size.apply((Object)this.yMin, (Object)this.yMax, (Object)this.ySize);
    }

    @Override
    public GeoRef get(GeoParam param) {
        return new GeoRef(this, param);
    }

    private T self() {
        return (T)this;
    }

    public T constrain(GeoParam param, @Nullable Constraint constraint) {
        if (constraint != null && constraint.axis() != null && constraint.axis() != param.axis) {
            throw new IllegalStateException("Attempted to apply constraint for axis: " + constraint.axis() + ", to Parameter: " + param);
        }
        if (param.axis == Axis.X) {
            this.constrainX(param, constraint);
        } else if (param.axis == Axis.Y) {
            this.constrainY(param, constraint);
        }
        return this.self();
    }

    public T clearConstraints() {
        this.ySize = null;
        this.yMax = null;
        this.yMin = null;
        this.xSize = null;
        this.xMax = null;
        this.xMin = null;
        this.xAxis = this.yAxis = AxisConfig.NONE;
        return this.self();
    }

    private void constrainX(GeoParam param, @Nullable Constraint constraint) {
        if (param == GeoParam.LEFT) {
            this.xMin = constraint;
        } else if (param == GeoParam.RIGHT) {
            this.xMax = constraint;
        } else if (param == GeoParam.WIDTH) {
            this.xSize = constraint;
        }
        this.xAxis = AxisConfig.getConfigFor(this.xMin, this.xMax, this.xSize);
        this.validate();
    }

    private void constrainY(GeoParam param, @Nullable Constraint constraint) {
        if (param == GeoParam.TOP) {
            this.yMin = constraint;
        } else if (param == GeoParam.BOTTOM) {
            this.yMax = constraint;
        } else if (param == GeoParam.HEIGHT) {
            this.ySize = constraint;
        }
        this.yAxis = AxisConfig.getConfigFor(this.yMin, this.yMax, this.ySize);
        this.validate();
    }

    public T strictMode(boolean strictMode) {
        this.strictMode = strictMode;
        return this.self();
    }

    public void validate() {
        if (this.strictMode) {
            if (this.xAxis.constraints != 2) {
                throw new IllegalStateException(String.format("X axis of element: %s is %s constrained!", this.getParent(), this.xAxis.constraints < 2 ? "under" : "over"));
            }
            if (this.yAxis.constraints != 2) {
                throw new IllegalStateException(String.format("Y axis of element: %s is %s constrained!", this.getParent(), this.yAxis.constraints < 2 ? "under" : "over"));
            }
        }
    }

    public void clearGeometryCache() {
        if (this.xMin != null) {
            this.xMin.markDirty();
        }
        if (this.xMax != null) {
            this.xMax.markDirty();
        }
        if (this.xSize != null) {
            this.xSize.markDirty();
        }
        if (this.yMin != null) {
            this.yMin.markDirty();
        }
        if (this.yMax != null) {
            this.yMax.markDirty();
        }
        if (this.ySize != null) {
            this.ySize.markDirty();
        }
        this.getChildren().forEach(ConstrainedGeometry::clearGeometryCache);
    }

    public Position getPosition() {
        return this.position;
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    public double xCenter() {
        return this.xMin() + this.xSize() / 2.0;
    }

    public double yCenter() {
        return this.yMin() + this.ySize() / 2.0;
    }

    public Rectangle.Mutable getEnclosingRect() {
        return this.addBoundsToRect(this.getRectangle().mutable());
    }

    public Rectangle.Mutable addBoundsToRect(Rectangle.Mutable enclosingRect) {
        enclosingRect.combine(this.getRectangle());
        for (GuiElement<?> element : this.getChildren()) {
            if (!element.isEnabled()) continue;
            element.addBoundsToRect(enclosingRect);
        }
        return enclosingRect;
    }

    public Rectangle.Mutable getChildBounds() {
        boolean set = false;
        for (GuiElement<?> element : this.getChildren()) {
            if (!element.isEnabled()) continue;
            if (!set) {
                this.childBounds.set(element.getRectangle());
                set = true;
                continue;
            }
            element.addBoundsToRect(this.childBounds);
        }
        if (!set) {
            this.childBounds.setPos(this.xMin(), this.yMin()).setSize(0.0, 0.0);
        }
        return this.childBounds;
    }

    public T placeInside(ConstrainedGeometry<?> reference, Constraints.LayoutPos position) {
        return this.placeInside(reference, position, 0.0, 0.0);
    }

    public T placeInside(ConstrainedGeometry<?> reference, Constraints.LayoutPos position, double xOffset, double yOffset) {
        switch (position) {
            case TOP_LEFT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
                break;
            }
            case TOP_CENTER: {
                ((ConstrainedGeometry)this.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.LEFT, Constraint.midPoint(reference.get(GeoParam.LEFT), reference.get(GeoParam.RIGHT), () -> this.xSize() / -2.0 + xOffset));
                break;
            }
            case TOP_RIGHT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case MIDDLE_RIGHT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.TOP, Constraint.midPoint(reference.get(GeoParam.TOP), reference.get(GeoParam.BOTTOM), () -> this.ySize() / -2.0 + yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case BOTTOM_RIGHT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case BOTTOM_CENTER: {
                ((ConstrainedGeometry)this.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.LEFT, Constraint.midPoint(reference.get(GeoParam.LEFT), reference.get(GeoParam.RIGHT), () -> this.xSize() / -2.0 + xOffset));
                break;
            }
            case BOTTOM_LEFT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
                break;
            }
            case MIDDLE_LEFT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.TOP, Constraint.midPoint(reference.get(GeoParam.TOP), reference.get(GeoParam.BOTTOM), () -> this.ySize() / -2.0 + yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
            }
        }
        return this.self();
    }

    public T placeOutside(ConstrainedGeometry<?> reference, Constraints.LayoutPos position) {
        return this.placeOutside(reference, position, 0.0, 0.0);
    }

    public T placeOutside(ConstrainedGeometry<?> reference, Constraints.LayoutPos position, double xOffset, double yOffset) {
        switch (position) {
            case TOP_LEFT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
                break;
            }
            case TOP_CENTER: {
                ((ConstrainedGeometry)this.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.LEFT, Constraint.midPoint(reference.get(GeoParam.LEFT), reference.get(GeoParam.RIGHT), () -> this.xSize() / -2.0 + xOffset));
                break;
            }
            case TOP_RIGHT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.BOTTOM, Constraint.relative(reference.get(GeoParam.TOP), yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case MIDDLE_RIGHT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.TOP, Constraint.midPoint(reference.get(GeoParam.TOP), reference.get(GeoParam.BOTTOM), () -> this.ySize() / -2.0 + yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case BOTTOM_RIGHT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.LEFT, Constraint.relative(reference.get(GeoParam.RIGHT), xOffset));
                break;
            }
            case BOTTOM_CENTER: {
                ((ConstrainedGeometry)this.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.LEFT, Constraint.midPoint(reference.get(GeoParam.LEFT), reference.get(GeoParam.RIGHT), () -> this.xSize() / -2.0 + xOffset));
                break;
            }
            case BOTTOM_LEFT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.TOP, Constraint.relative(reference.get(GeoParam.BOTTOM), yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
                break;
            }
            case MIDDLE_LEFT: {
                ((ConstrainedGeometry)this.constrain(GeoParam.TOP, Constraint.midPoint(reference.get(GeoParam.TOP), reference.get(GeoParam.BOTTOM), () -> this.ySize() / -2.0 + yOffset))).constrain(GeoParam.RIGHT, Constraint.relative(reference.get(GeoParam.LEFT), xOffset));
            }
        }
        return this.self();
    }
}

